package w83b.w83bDAO;


import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bListaDelegadosBean;
import w83b.w83bBeans.W83bListadosActasVivasCentroRepeBean;
import w83b.w83bBeans.W83bListadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bColegiosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bListImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bListadosActasVivasCentroRepeBD;
import w83b.w83bDAO.w83bConstantesBD.W83bListadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMotivosBajaDelegadoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMunicipiosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bProvinciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bListadosDAO.
 * @author a
 */
public class W83bListadosDAO implements W83bIListadosDAO {
	
	/**
	 * buscarEmpresasVariosPreavisos.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public java.util.List buscarEmpresasVariosPreavisos(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT "); 
		strSql.append(W83bListadosBD.cif).append(", ");
		strSql.append(W83bListadosBD.codCentro).append(", ");
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaEntrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bListadosBD.numPreaviso).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaInicio).append(",?) AS ").append(W83bListadosBD.fechaInicio).append(" , ");
		strSql.append(W83bListadosBD.municipio).append(", ");
		strSql.append(W83bListadosBD.preavisoGlobal).append(", ");
		strSql.append(W83bListadosBD.observaciones).append(", ");
		strSql.append(W83bListadosBD.promotores).append(", ");
		strSql.append(W83bListadosBD.promotoreseu);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bListadosBD.vistaEmpVariosPre);
	    strSql.append("(?,?))");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEntradaDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		}
		else{
			params.add("01/01/1111");
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEntradaHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		}
		else{
			params.add("01/01/9999");
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			strSql.append(" WHERE ");
			strSql.append(W83bListadosBD.fechaEntrada).append(">=").append("TO_DATE(?,'dd/MM/yyyy')");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEntradaDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
				strSql.append(" AND ");
			}
			else{
				strSql.append(" WHERE ");
			}
			strSql.append(W83bListadosBD.fechaEntrada).append("<=").append("TO_DATE(?,'dd/MM/yyyy')");
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEntradaHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if(StringUtils.isNotEmpty(param.getTerritorio())){
				strSql.append(" AND ");
			}
			strSql.append(W83bListadosBD.territorio).append("=?");
			params.add(param.getTerritorio());
		}
		
		List listaEmpresasVariosPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaEmpresasVariosPreavisos;		
	}
	
	/**
	 * buscarLibroRegistroPreavisos.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public java.util.List buscarLibroRegistroPreavisos(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean restriccion = false;
		
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaEntrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bListadosBD.numPreaviso).append(", ");
		strSql.append(W83bListadosBD.cif).append(", ");
		strSql.append(W83bListadosBD.codCentro).append(", ");
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaInicio).append(",?) AS ").append(W83bListadosBD.fechaInicio).append(" , ");
		strSql.append(W83bListadosBD.municipio).append(", ");
		strSql.append(W83bListadosBD.preavisoGlobal).append(", ");
		strSql.append(W83bListadosBD.observaciones).append(", ");
		strSql.append(W83bListadosBD.promotores).append(", ");
		strSql.append(W83bListadosBD.promotoreseu);
		strSql.append(" FROM ").append(W83bListadosBD.vistaLibroRegPre);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			restriccion=true;
			strSql.append(W83bListadosBD.fechaEntrada).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			if (restriccion){
				strSql.append(" AND ");
			}
			restriccion=true;
			strSql.append(W83bListadosBD.fechaEntrada).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if (restriccion){
			strSql.append(" AND ");
		}
		strSql.append("((").append(W83bListadosBD.anyoPreaviso).append("=").append("?");
		params.add(param.getAnyoPreaviso());
		strSql.append(" AND ");
		strSql.append(W83bListadosBD.nPre).append(">=").append("?").append(")");
		params.add(param.getNumPreaviso());	
		strSql.append(" OR ");
		strSql.append("(").append(W83bListadosBD.anyoPreaviso).append(">").append("?");
		params.add(param.getAnyoPreaviso());
		strSql.append(" AND ");
		strSql.append(W83bListadosBD.nPre).append(">=").append("0").append("))");
		if(StringUtils.isNotEmpty(param.getNumTerritorio())){
			if (restriccion){
				strSql.append(" AND ");
			}
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getNumTerritorio());
		}
		
		List listaEmpresasVariosPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaEmpresasVariosPreavisos;		
	}
	
	/**
	 * buscarRelacionAlfabeticaPreavisos.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public java.util.List buscarRelacionAlfabeticaPreavisos(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT "); 
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaEntrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bListadosBD.numPreaviso).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaInicio).append(",?) AS ").append(W83bListadosBD.fechaInicio).append(" , ");
		strSql.append(W83bListadosBD.cif).append(", ");
		strSql.append(W83bListadosBD.codCentro).append(", ");
		strSql.append(W83bListadosBD.municipio).append(", ");
		strSql.append(W83bListadosBD.preavisoGlobal).append(", ");
		strSql.append(W83bListadosBD.observaciones).append(", ");
		strSql.append(W83bListadosBD.promotores).append(", ");
		strSql.append(W83bListadosBD.promotoreseu);
		strSql.append(" FROM ").append(W83bListadosBD.vistaRelAlfabPre);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			strSql.append(W83bListadosBD.fechaEntrada).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" AND ");
			strSql.append(W83bListadosBD.territorio).append("=?");
			params.add(param.getTerritorio());
		}
		
		
		List listaEmpresasVariosPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaEmpresasVariosPreavisos;		
	}
	
	/**
	 * buscarLibroRegistroActas.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public java.util.List buscarLibroRegistroActas(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean restriccion = false;
		
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaEntrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bListadosBD.anyoActa).append(", ");
		strSql.append(W83bListadosBD.territorio).append(", ");
		strSql.append(W83bListadosBD.ver).append(", ");
		strSql.append(W83bListadosBD.numActa).append(", ");
		strSql.append(W83bListadosBD.nPre).append(", ");
		strSql.append(W83bListadosBD.anopreaviso).append(", ");
		strSql.append(W83bListadosBD.cif).append(", ");
		strSql.append(W83bListadosBD.codCentro).append(", ");
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append(W83bListadosBD.direccion).append(", ");
		strSql.append(W83bListadosBD.municipio).append(", ");
		strSql.append(W83bListadosBD.convenio).append(", ");
		strSql.append(W83bListadosBD.convenioeu).append(", ");
		strSql.append(W83bListadosBD.numelectores).append(", ");
		strSql.append(W83bListadosBD.numactaint).append(", ");
		strSql.append(W83bListadosBD.provincia).append(", ");
		strSql.append(W83bListadosBD.numrep);
		strSql.append(" FROM ").append(W83bListadosBD.vistaLibroRegActas);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			restriccion=true;
			strSql.append(W83bListadosBD.fechaEntrada).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			if (restriccion){
				strSql.append(" AND ");
			}
			else{
				restriccion=true;
			}
			strSql.append(W83bListadosBD.fechaEntrada).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if (restriccion){
			strSql.append(" AND ");
		}
		strSql.append("((").append(W83bListadosBD.anyoActa).append("=").append("?");
		params.add(param.getAnyoActa());
		strSql.append(" AND ");
		strSql.append(W83bListadosBD.numActa).append(">=").append("?").append(")");
		params.add(param.getNumActa());	
		strSql.append(" OR ");
		strSql.append("(").append(W83bListadosBD.anyoActa).append(">").append("?");
		params.add(param.getAnyoActa());
		strSql.append(" AND ");
		strSql.append(W83bListadosBD.numActa).append(">=").append("0").append("))");
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if (restriccion){
				strSql.append(" AND ");
			}
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaActas;		
	}
	
	/**
	 * buscarResolDenReqNoSub.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public java.util.List buscarResolDenFaltapreaviso(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaEntrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bListadosBD.ver).append(", ");
		strSql.append(W83bListadosBD.territorio).append(", ");
		strSql.append(W83bListadosBD.anyoActa).append(", ");
		strSql.append(W83bListadosBD.numActa).append(", ");
		strSql.append(W83bListadosBD.nPre).append(", ");
		strSql.append(W83bListadosBD.anopreaviso).append(", ");
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append(W83bListadosBD.direccion).append(", ");
		strSql.append(W83bListadosBD.municipio).append(", ");
		strSql.append(W83bListadosBD.numelectores).append(", ");
		strSql.append(W83bListadosBD.numrep).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fimpug).append(",?) AS ").append(W83bListadosBD.fimpug).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fregdef).append(",?) AS ").append(W83bListadosBD.fregdef);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(" FROM ").append(W83bListadosBD.vistaResolDenFaltapreaviso);
		strSql.append(" WHERE ");
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			strSql.append(W83bListadosBD.fechaEntrada).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
				strSql.append(" AND ");
			}
			strSql.append(W83bListadosBD.fechaEntrada).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if(StringUtils.isNotEmpty(param.getTerritorio())){
				strSql.append(" AND ");
			}
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
		}
		params.add(param.getTerritorio());
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaActas;		
	}
	
	/**
	 * buscarResolDenLaudoNegativo.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public java.util.List buscarResolDenLaudoNegativo(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT "); 
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaEntrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");
		strSql.append(W83bListadosBD.territorio).append(", ");
		strSql.append(W83bListadosBD.anyoActa).append(", ");
		strSql.append(W83bListadosBD.numActa).append(", ");
		strSql.append(W83bListadosBD.nPre).append(", ");
		strSql.append(W83bListadosBD.anopreaviso).append(", ");
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append(W83bListadosBD.direccion).append(", ");
		strSql.append(W83bListadosBD.municipio).append(", ");
		strSql.append(W83bListadosBD.numelectores).append(", ");
		strSql.append(W83bListadosBD.numrep).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fimpug).append(",?) AS ").append(W83bListadosBD.fimpug).append(", ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fregdef).append(",?) AS ").append(W83bListadosBD.fregdef);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bListadosBD.w83bresoldeneglaudonegativo);
	    strSql.append("(?,?,?))");
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    params.add(param.getFechaLaudo());
	    params.add(param.getTerritorio());
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaActas;		
	}

	/**
	 * buscarReqMesasActas.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public List buscarReqMesasActas(W83bListadosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean restriccion = false;
		
		strSql.append("SELECT ");
		strSql.append("TO_CHAR(").append(W83bListadosBD.fechaEntrada).append(",?) AS ").append(W83bListadosBD.fechaEntrada).append(" , ");

		strSql.append(W83bListadosBD.numActa).append(", ");
		strSql.append(W83bListadosBD.anyoActa).append(", ");
		strSql.append(W83bListadosBD.numPreaviso).append(", ");
		strSql.append(W83bListadosBD.anopreaviso).append(", ");
		strSql.append(W83bListadosBD.territorio).append(", ");
		strSql.append(W83bListadosBD.cif).append(", ");
		strSql.append(W83bListadosBD.codCentro).append(", ");
		strSql.append(W83bListadosBD.numCentro).append(", ");
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append(W83bListadosBD.direccion).append(", ");
		strSql.append(W83bListadosBD.municipio).append(", ");
		strSql.append(W83bListadosBD.comarca).append(", ");
		strSql.append(W83bListadosBD.numtrabajadores).append(", ");
		strSql.append(W83bListadosBD.numrep);
		strSql.append(" FROM ").append(W83bListadosBD.vistaRecMesasActas);
		strSql.append(" WHERE ");
		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			restriccion=true;
			strSql.append(W83bListadosBD.fechaEntrada).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			
			if (restriccion){
				strSql.append(" AND ");
			}
			else{
				restriccion=true;
			}
			strSql.append(W83bListadosBD.fechaEntrada).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if (restriccion){
				strSql.append(" AND ");
			}
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaActas;	
	}
	/**
	 * buscarEmpresasVariosCentros.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public List buscarEmpresasVariosCentros(W83bListadosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean restriccion = false;
		
		strSql.append("SELECT "); 
		strSql.append(W83bListadosBD.numActa).append(", ");
		strSql.append(W83bListadosBD.cif).append(", ");
		strSql.append(W83bListadosBD.codCentro).append(", ");
		strSql.append(W83bListadosBD.convenio).append(", ");
		strSql.append(W83bListadosBD.convenioeu).append(", ");
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append(W83bListadosBD.direccion).append(", MUN.").append(W83bMunicipiosBD.nomMunic_Cast).append(" AS ");
		strSql.append(W83bListadosBD.municipio).append(", ");
		strSql.append(W83bListadosBD.cnae).append(", ");
		strSql.append(W83bListadosBD.codpostal).append(", ");
		strSql.append(W83bListadosBD.numelectores).append(", ");
		strSql.append(W83bListadosBD.numcandidatos);
		strSql.append(" FROM ").append(W83bListadosBD.vistaEmpresasVariosCentros).append(" VISTA,");
		strSql.append(W83bMunicipiosBD.municipiosTable).append(" MUN  ,");
		strSql.append(W83bProvinciasBD.provinciasTable).append(" PROV ");
		strSql.append(" WHERE ");
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			restriccion=true;
			strSql.append(W83bListadosBD.fechaEntrada).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			if (restriccion){
				strSql.append(" AND ");
			}
			else{
				restriccion=true;
			}
			strSql.append(W83bListadosBD.fechaEntrada).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if (restriccion){
				strSql.append(" AND ");
			}
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		strSql.append(" AND VISTA.PROVI=PROV.ID(+) ");
		strSql.append(" AND VISTA.MUNI=MUN.ID(+) ");
		strSql.append(" AND PROV.ID=MUN.").append(W83bMunicipiosBD.codProvincia);
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaActas;	
	}
	
	/**
	 * buscarActasPorCentros.
	 *
	 * @param cif the cif
	 * @param fechaDesde the fecha desde
	 * @param fechaHasta the fecha hasta
	 * @param idioma the idioma
	 * @param usuario the usuario
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public List buscarActasPorCentros(String cif,String fechaDesde,String fechaHasta,String idioma,W83bUsuarioXLNetsBean usuario) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		
		strSql.append("SELECT COUNT(DISTINCT ("); 
		strSql.append(W83bActasBD.codCentro).append(")) AS ");
		strSql.append(W83bListadosBD.codCentro).append(" ,  ");
		strSql.append(W83bCentroTrabajoBD.codNifCif).append(" AS ");
		strSql.append(W83bListadosBD.cif);
		strSql.append(" FROM ");
		strSql.append(W83bActasBD.actasTable).append(", ");
		strSql.append(W83bCentroTrabajoBD.J7301S00).append(" WHERE ");
		strSql.append(W83bActasBD.codCentro).append("=").append(W83bCentroTrabajoBD.codigoCentro).append(" AND ");
		
		if(StringUtils.isNotEmpty(fechaDesde)){
			//strSql.append(" AND ");
			strSql.append(W83bActasBD.fechaEntrada).append(">=").append("TO_DATE(?,?)");
			params.add(fechaDesde);
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		}
		if(StringUtils.isNotEmpty(fechaDesde) && StringUtils.isNotEmpty(fechaHasta)){
			strSql.append(" AND ");
		}
		if(StringUtils.isNotEmpty(fechaHasta)){			
			strSql.append(W83bActasBD.fechaEntrada).append("<=").append("TO_DATE(?,?)");
			params.add(fechaHasta);
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		}
		strSql.append(" GROUP BY CCIF_001");
				
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,usuario, null);
		
		return listaActas;	
	}
	/**
	 * Buscar territorio otra direccion.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarTerritorioOtraDireccion(W83bListadosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean restriccion = false;
		
		strSql.append("SELECT TACT."); 
		strSql.append(W83bActasBD.numActa).append(", TACT.");
		strSql.append(W83bActasBD.codTerritActa).append(", TACT.");
		strSql.append(W83bActasBD.anyoActa).append(", TACT.");
		strSql.append(W83bActasBD.versionActa).append(", TACT.");
		strSql.append(W83bActasBD.codCentro).append(", TCT.");
		strSql.append(W83bCentroTrabajoBD.codNifCif).append(", TCT.");
		strSql.append(W83bCentroTrabajoBD.ncentroTrab).append(", TCT.");
		strSql.append(W83bCentroTrabajoBD.codigoCentro).append(", TCT.");
		strSql.append(W83bCentroTrabajoBD.codProvinciaCentro).append(", TPROV.");
		strSql.append(W83bProvinciasBD.codProvinc).append(", TPROV.");
		strSql.append(W83bProvinciasBD.nomProvinc_Cast);
				
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" TACT ");
		strSql.append(", ").append(W83bCentroTrabajoBD.tablaCTDesa).append(" TCT");
		strSql.append(", ").append(W83bProvinciasBD.provinciasTable).append(" TPROV");
		
		strSql.append(" WHERE ");
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if (restriccion){
				strSql.append(" AND TACT.");
			}
			strSql.append(W83bActasBD.codTerritActa).append("=").append("?");
			params.add(param.getTerritorio());
			restriccion = true;
		}
		strSql.append(" AND TACT.").append(W83bActasBD.validada).append(" =1 ");
		strSql.append(" AND TACT.").append(W83bActasBD.fechaBaja).append(" is null ");
		strSql.append(" AND TACT.").append(W83bActasBD.codCentro).append("= TCT.").append(W83bCentroTrabajoBD.codigoCentro);
		strSql.append(" AND TACT.").append(W83bActasBD.codTerritActa).append(" <> TCT.").append(W83bCentroTrabajoBD.codProvinciaCentro);
		strSql.append(" AND TPROV.").append(W83bProvinciasBD.codProvinc).append(" =  TCT.").append(W83bCentroTrabajoBD.codProvinciaCentro);
		
		strSql.append(" AND TACT.").append(W83bActasBD.versionActa).append(" =  (SELECT MAX(").append(W83bActasBD.versionActa);
		strSql.append(") FROM ").append(W83bActasBD.actasTable).append(" TACTAS2 ");
		strSql.append(" WHERE TACT.").append(W83bActasBD.numActa).append("= TACTAS2.").append(W83bActasBD.numActa);
		strSql.append(" AND TACT.").append(W83bActasBD.anyoActa).append("= TACTAS2.").append(W83bActasBD.anyoActa);
		strSql.append(" AND TACT.").append(W83bActasBD.codTerritActa).append("= TACTAS2.").append(W83bActasBD.codTerritActa).append(") ");
				
		strSql.append(" ORDER BY TACT.").append(W83bActasBD.anyoActa).append(", TACT.").append(W83bActasBD.numActa);
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), "TerritorioOtraDireccion");
		
		return listaActas;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIListadosDAO#buscarRelImpugnaciones(w83b.w83bBeans.W83bListImpugnacionesBean)
	 */
	public List buscarRelImpugnaciones(W83bListImpugnacionesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean conc=false;
		
		strSql.append("SELECT ");
		strSql.append(W83bListImpugnacionesBD.n_actalit).append(" AS ").append(W83bListImpugnacionesBD.n_acta).append(", ");
		strSql.append(W83bListImpugnacionesBD.agno_actalit).append(" AS ").append(W83bListImpugnacionesBD.agno_acta).append(", ");
		strSql.append(W83bListImpugnacionesBD.c_territlit).append(" AS ").append(W83bListImpugnacionesBD.c_territ).append(", ");
		strSql.append(W83bListImpugnacionesBD.versionlit).append(" AS ").append(W83bListImpugnacionesBD.version).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fechaEntradalit).append(",?) AS ").append(W83bActasBD.fechaEntrada).append(", ");
		strSql.append(W83bListImpugnacionesBD.observacioneslit).append(" AS ").append(W83bActasBD.observaciones).append(", ");
		strSql.append(W83bListImpugnacionesBD.codCentrolit).append(" AS ").append(W83bActasBD.codCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.codigoCentrolit).append(" AS ").append(W83bCentroTrabajoBD.codigoCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.razonSociallit).append(" AS ").append(W83bCentroTrabajoBD.razonSocial).append(", ");
		strSql.append(W83bListImpugnacionesBD.domicilioCentrolit).append(" AS ").append(W83bCentroTrabajoBD.domicilioCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.n_impuglit).append(" AS ").append(W83bImpugnacionesBD.n_impug).append(", ");
		strSql.append(W83bListImpugnacionesBD.ano_impuglit).append(" AS ").append(W83bImpugnacionesBD.ano_impug).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.f_impuglit).append(",?) AS ").append(W83bImpugnacionesBD.f_impug).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fechaBajalit).append(",?) AS ").append(W83bActasBD.fechaBaja).append(", ");
		strSql.append(W83bListImpugnacionesBD.resultadoLaudoslit).append(" AS ").append(W83bImpugnacionesBD.resultadoLaudos).append(", ");
		strSql.append(W83bListImpugnacionesBD.orderby);
		
		strSql.append(" FROM ").append(W83bListImpugnacionesBD.vistaImpugrelacionadas);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			conc=true;
			strSql.append(" WHERE ");
			strSql.append(W83bListImpugnacionesBD.f_impuglit).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			if (conc){
				strSql.append(" AND ");
			}
			else{
				strSql.append(" WHERE ");
			}
			strSql.append(W83bListImpugnacionesBD.f_impuglit).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			conc=true;
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if (conc){
				strSql.append(" AND ");
			}
			else{
				strSql.append(" WHERE ");
			}
			strSql.append(W83bListImpugnacionesBD.c_territlit).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListImpugnacionesBean.class,param.getUsuarioBean(), null);
		 
		
		return listaActas;
	}

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIListadosDAO#buscarPendientesImpugnaciones(w83b.w83bBeans.W83bListImpugnacionesBean)
	 */
	public List buscarPendientesImpugnaciones(W83bListImpugnacionesBean param)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean restriccion = false;
		
		strSql.append("SELECT ");
		strSql.append(W83bListImpugnacionesBD.n_actalit).append(" AS ").append(W83bListImpugnacionesBD.n_acta).append(", ");
		strSql.append(W83bListImpugnacionesBD.agno_actalit).append(" AS ").append(W83bListImpugnacionesBD.agno_acta).append(", ");
		strSql.append(W83bListImpugnacionesBD.c_territlit).append(" AS ").append(W83bListImpugnacionesBD.c_territ).append(", ");
		strSql.append(W83bListImpugnacionesBD.versionlit).append(" AS ").append(W83bListImpugnacionesBD.version).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fechaEntradalit).append(",?) AS ").append(W83bActasBD.fechaEntrada).append(", ");
		strSql.append(W83bListImpugnacionesBD.observacioneslit).append(" AS ").append(W83bActasBD.observaciones).append(", ");
		strSql.append(W83bListImpugnacionesBD.codCentrolit).append(" AS ").append(W83bActasBD.codCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.codigoCentrolit).append(" AS ").append(W83bCentroTrabajoBD.codigoCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.razonSociallit).append(" AS ").append(W83bCentroTrabajoBD.razonSocial).append(", ");
		strSql.append(W83bListImpugnacionesBD.domicilioCentrolit).append(" AS ").append(W83bCentroTrabajoBD.domicilioCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.n_impuglit).append(" AS ").append(W83bImpugnacionesBD.n_impug).append(", ");
		strSql.append(W83bListImpugnacionesBD.ano_impuglit).append(" AS ").append(W83bImpugnacionesBD.ano_impug).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.f_impuglit).append(",?) AS ").append(W83bImpugnacionesBD.f_impug).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fechaBajalit).append(",?) AS ").append(W83bActasBD.fechaBaja).append(", ");
		strSql.append(W83bListImpugnacionesBD.resultadoLaudoslit).append(" AS ").append(W83bImpugnacionesBD.resultadoLaudos).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fdeseslit).append(",?) AS ").append(W83bListImpugnacionesBD.fdeses).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fenvarblit).append(",?) AS ").append(W83bListImpugnacionesBD.fenvarb).append(", ");
		strSql.append(W83bListImpugnacionesBD.dniArblit).append(" AS ").append(W83bListImpugnacionesBD.dniArb).append(", ");
		strSql.append(W83bListImpugnacionesBD.nomArblit).append(" AS ").append(W83bListImpugnacionesBD.nomArb).append(", ");
		strSql.append(W83bListImpugnacionesBD.orderby);
		
		strSql.append(" FROM ").append(W83bListImpugnacionesBD.vistaImpugnaciones);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(" WHERE ");
		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			restriccion=true;
			strSql.append(W83bListImpugnacionesBD.f_impuglit).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			if (restriccion){
				strSql.append(" AND ");
			}
			else{
				restriccion=true;
			}
			strSql.append(W83bListImpugnacionesBD.f_impuglit).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if (restriccion){
				strSql.append(" AND ");
			}
			strSql.append(W83bListImpugnacionesBD.c_territlit).append("=").append("?");
			params.add(param.getTerritorio());
		}
		//para filtrar por numero de impugnacin, tengo que hacer un numrico combinacin de ao+numImpugnacion
		String agnoD = param.getAgnoImpugnacionDesde();
		String agnoH = param.getAgnoImpugnacionHasta();
		String numD = param.getNumImpugnacionDesde();
		String numH = param.getNumImpugnacionHasta();
		if(StringUtils.isNotEmpty(param.getAgnoImpugnacionDesde())){
			agnoD = param.getAgnoImpugnacionDesde();
		}else{
			agnoD = "0000";
		}
		if(StringUtils.isNotEmpty(param.getAgnoImpugnacionHasta())){
			agnoH = param.getAgnoImpugnacionHasta();
		}else{
			agnoH = "9999";
		}		
		if(StringUtils.isNotEmpty(param.getNumImpugnacionDesde())){
			numD = param.getNumImpugnacionDesde();
			int ld = numD.length();
			int tot = 6;
			while(ld<tot){
				numD ="0"+numD;//NOPMD
				ld++;
			}
		}else{
			numD = "000000";
		}
		if(StringUtils.isNotEmpty(param.getNumImpugnacionHasta())){
			numH = param.getNumImpugnacionHasta();	
			int lh = numH.length();
			int tot = 6;
			while(lh<tot){
				numH ="0"+numH;//NOPMD
				lh++;
			}
		}else{
			numH = "999999";
		}
		strSql.append(" AND (").append(W83bListImpugnacionesBD.vista_numimpug).append(" BETWEEN ").append(" ? AND ? )");
		params.add(agnoD+numD);
		params.add(agnoH+numH);
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListImpugnacionesBean.class,param.getUsuarioBean(), null);
	
		return listaActas;
	}

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIListadosDAO#buscarResueltasImpugnaciones(w83b.w83bBeans.W83bListImpugnacionesBean)
	 */
	public List buscarResueltasImpugnaciones(W83bListImpugnacionesBean param)
			throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean restriccion = false;
		
		strSql.append("SELECT ");
		strSql.append(W83bListImpugnacionesBD.n_actalit).append(" AS ").append(W83bListImpugnacionesBD.n_acta).append(", ");
		strSql.append(W83bListImpugnacionesBD.agno_actalit).append(" AS ").append(W83bListImpugnacionesBD.agno_acta).append(", ");
		strSql.append(W83bListImpugnacionesBD.c_territlit).append(" AS ").append(W83bListImpugnacionesBD.c_territ).append(", ");
		strSql.append(W83bListImpugnacionesBD.versionlit).append(" AS ").append(W83bListImpugnacionesBD.version).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fechaEntradalit).append(",?) AS ").append(W83bActasBD.fechaEntrada).append(", ");
		strSql.append(W83bListImpugnacionesBD.observacioneslit).append(" AS ").append(W83bActasBD.observaciones).append(", ");
		strSql.append(W83bListImpugnacionesBD.codCentrolit).append(" AS ").append(W83bActasBD.codCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.codigoCentrolit).append(" AS ").append(W83bCentroTrabajoBD.codigoCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.razonSociallit).append(" AS ").append(W83bCentroTrabajoBD.razonSocial).append(", ");
		strSql.append(W83bListImpugnacionesBD.domicilioCentrolit).append(" AS ").append(W83bCentroTrabajoBD.domicilioCentro).append(", ");
		strSql.append(W83bListImpugnacionesBD.n_impuglit).append(" AS ").append(W83bImpugnacionesBD.n_impug).append(", ");
		strSql.append(W83bListImpugnacionesBD.ano_impuglit).append(" AS ").append(W83bImpugnacionesBD.ano_impug).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.f_impuglit).append(",?) AS ").append(W83bImpugnacionesBD.f_impug).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fechaBajalit).append(",?) AS ").append(W83bActasBD.fechaBaja).append(", ");
		strSql.append(W83bListImpugnacionesBD.resultadoLaudoslit).append(" AS ").append(W83bImpugnacionesBD.resultadoLaudos).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fdeseslit).append(",?) AS ").append(W83bListImpugnacionesBD.fdeses).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fenvarblit).append(",?) AS ").append(W83bListImpugnacionesBD.fenvarb).append(", ");
		strSql.append(W83bListImpugnacionesBD.dniArblit).append(" AS ").append(W83bListImpugnacionesBD.dniArb).append(", ");
		strSql.append(W83bListImpugnacionesBD.nomArblit).append(" AS ").append(W83bListImpugnacionesBD.nomArb).append(", ");
		strSql.append("TO_CHAR(").append(W83bListImpugnacionesBD.fLaudoLaudoslit).append(",?) AS ").append(W83bImpugnacionesBD.fLaudoLaudos).append(", ");
		strSql.append(W83bListImpugnacionesBD.anyoLaudoLaudoslit).append(" AS ").append(W83bImpugnacionesBD.anyoLaudoLaudos).append(", "); 
		strSql.append(W83bListImpugnacionesBD.numLaudoLaudoslit).append(" AS ").append(W83bImpugnacionesBD.numLaudoLaudos).append(", "); 
		strSql.append(W83bListImpugnacionesBD.descEusResultadoLaudolit).append(" AS ").append(W83bImpugnacionesBD.descEusResultadoLaudo).append(", ");
		strSql.append(W83bListImpugnacionesBD.descResultadoLaudolit).append(" AS ").append(W83bImpugnacionesBD.descResultadoLaudo).append(", "); 
		strSql.append(W83bListImpugnacionesBD.orderby);
		
		strSql.append(" FROM ").append(W83bListImpugnacionesBD.vistaImpugnaciones);
		
		strSql.append(" WHERE ");

		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		//Para las fechas de impugnacin
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			restriccion=true;
			strSql.append(W83bListImpugnacionesBD.f_impuglit).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			if (restriccion){
				strSql.append(" AND ");
			}
			else{
				restriccion=true;
			}
			strSql.append(W83bListImpugnacionesBD.f_impuglit).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		//Para las fechas de laudos
		if(StringUtils.isNotEmpty(param.getFechaLaudoDesde())){
			if (restriccion){
				strSql.append(" AND ");
			}
			else{
				restriccion=true;
			}
			strSql.append(W83bListImpugnacionesBD.fLaudoLaudoslit).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaLaudoDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaLaudoHasta())){
			if (restriccion){
				strSql.append(" AND ");
			}
			else{
				restriccion=true;
			}
			strSql.append(W83bListImpugnacionesBD.fLaudoLaudoslit).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaLaudoHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		//para filtrar por territorio
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if (restriccion){
				strSql.append(" AND ");
			}else{
				restriccion=true;
			}
			strSql.append(W83bListImpugnacionesBD.c_territlit).append("=").append("?");
			params.add(param.getTerritorio());
		}
		//para filtrar por numero de impugnacin, tengo que hacer un numrico combinacin de ao+numImpugnacion
		String agnoD1 = param.getAgnoImpugnacionDesde();
		String agnoH1 = param.getAgnoImpugnacionHasta();
		String numD1 = param.getNumImpugnacionDesde();
		String numH1 = param.getNumImpugnacionHasta();
		if(StringUtils.isNotEmpty(param.getAgnoImpugnacionDesde())){
			agnoD1 = param.getAgnoImpugnacionDesde();
		}else{
			agnoD1 = "0000";
		}
		if(StringUtils.isNotEmpty(param.getAgnoImpugnacionHasta())){
			agnoH1 = param.getAgnoImpugnacionHasta();
		}else{
			agnoH1 = "9999";
		}		
		if(StringUtils.isNotEmpty(param.getNumImpugnacionDesde())){
			numD1 = param.getNumImpugnacionDesde();
			int ld = numD1.length();
			int tot = 6;
			while(ld<tot){
				numD1 ="0"+numD1;//NOPMD
				ld++;
			}
		}else{
			numD1 = "000000";
		}
		if(StringUtils.isNotEmpty(param.getNumImpugnacionHasta())){
			numH1 = param.getNumImpugnacionHasta();	
			int lh = numH1.length();
			int tot = 6;
			while(lh<tot){
				numH1 ="0"+numH1;//NOPMD
				lh++;
			}
		}else{
			numH1 = "999999";
		}
		//para los nmeros de impugnacin
		if (restriccion){
			strSql.append(" AND (");
		}else{
			strSql.append(" (");
		}
		strSql.append(W83bListImpugnacionesBD.vista_numimpug).append(" BETWEEN ").append(" ? AND ? )");
		params.add(agnoD1+numD1);
		params.add(agnoH1+numH1);

				//para filtrar por numero de laudos, tengo que hacer un numrico combinacin de ao+numLaudo
				String agnolaudoD = param.getAgnoLaudoDesde();
				String agnolaudoH = param.getAgnoLaudoHasta();
				String numlaudoD = param.getNumLaudoDesde();
				String numlaudoH = param.getNumImpugnacionHasta();
				if(StringUtils.isNotEmpty(param.getAgnoLaudoDesde())){
					agnolaudoD = param.getAgnoLaudoDesde();
				}else{
					agnolaudoD = "0000";
				}
				if(StringUtils.isNotEmpty(param.getAgnoLaudoHasta())){
					agnolaudoH = param.getAgnoLaudoHasta();
				}else{
					agnolaudoH = "9999";
				}		
				if(StringUtils.isNotEmpty(param.getNumLaudoDesde())){
					numlaudoD = param.getNumLaudoDesde();
					int ld = numlaudoD.length();
					int tot = 3;
					while(ld<tot){
						numlaudoD ="0"+numlaudoD;//NOPMD
						ld++;
					}
				}else{
					numlaudoD = "000";
				}
				if(StringUtils.isNotEmpty(param.getNumLaudoHasta())){
					numlaudoH = param.getNumLaudoHasta();	
					int lh = numlaudoH.length();
					int tot = 3;
					while(lh<tot){
						numlaudoH ="0"+numlaudoH;//NOPMD
						lh++;
					}
				}else{
					numlaudoH = "999";
				}
				//para los nmeros de impugnacin
				strSql.append(" AND (").append(W83bListImpugnacionesBD.numlaudocomp).append(" BETWEEN ").append(" ? AND ? )");
				params.add(agnolaudoD+numlaudoD);
				params.add(agnolaudoH+numlaudoH);
				
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListImpugnacionesBean.class,param.getUsuarioBean(), null);
	
		return listaActas;
	}
	
	public java.lang.String obtenerdescprovincia(W83bListImpugnacionesBean param) throws Exception{
		List params=new ArrayList();
		StringBuffer strSql=new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ");
		strSql.append(W83bProvinciasBD.nomProvinc_Cast).append(" AS ").append(W83bListImpugnacionesBD.desc_prov);
		strSql.append(" FROM ");
		strSql.append(W83bProvinciasBD.provinciasTable);
		strSql.append(" WHERE ");
		strSql.append(W83bProvinciasBD.codProvinc).append("=?");
		params.add(param.getTerritorio());
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bListImpugnacionesBean.class,param.getUsuarioBean(), null);
		if(lista.size()>0){
			return (String) (((W83bListImpugnacionesBean)lista.get(0)).getDescTerritorio());
		}
		return null;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIListadosDAO#actFechaRegResolDen(java.util.List)
	 */
	public java.lang.String actFechaRegResolDen(List param) throws Exception{
		List params;
		W83bListadosBean lb;
		for (int i=0;i<param.size();i++){
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
			params = new ArrayList();//NOPMD
			lb = (W83bListadosBean)param.get(i);
			strSql.append("UPDATE ");
			strSql.append(W83bActasBD.tablaActas);
			strSql.append(" SET ");
			strSql.append(W83bActasBD.fecRegDefinitivo).append(" = TO_DATE(?,'DD/mm/YYYY') ");
			strSql.append(" WHERE ");
			strSql.append(W83bActasBD.numActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.anyoActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.codTerritActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.versionActa).append("=?");
		    params.add(lb.getFechaResolucion());
			params.add(lb.getNumActa());
			params.add(lb.getAnyoActa());
			params.add(lb.getTerritorio());
			params.add(lb.getVer());
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}
		
		
		return "0";		
	}
	
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIListadosDAO#obtenerMunicipio(w83b.w83bBeans.W83bListadosBean)
	 */
	public w83b.w83bBeans.W83bListadosBean obtenerMunicipio(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		String m="";
		String p="";
		List params = new ArrayList();
		
	    strSql.append("SELECT ");

	    strSql.append(W83bListadosBD.dso).append(" AS ").append(W83bListadosBD.descmunicipio);
	    
	    strSql.append(", ");
	    		
	    strSql.append(W83bListadosBD.comarcaid).append(" AS ").append(W83bListadosBD.idcomarca);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bListadosBD.tablamunicipio);
	    
	    strSql.append(" WHERE ");
	    
	    strSql.append(W83bListadosBD.provinciaid).append("=?");
	    
	    strSql.append(" AND ");
	    
	    strSql.append(W83bListadosBD.id).append("=?");
	    
	    if (param.getProvincia().length()==1){
	    	p="0"+param.getProvincia();
	    }
	    else{
	    	p=param.getProvincia();
	    }
	    
	    if (param.getMunicipio().length()==1){
	    	m="00"+param.getMunicipio();
	    }else if (param.getMunicipio().length()==2){
	    	m="0"+param.getMunicipio();
	    }
	    else{
	    	m=param.getMunicipio();
	    }
	    
	    params.add(p);
	    params.add(m);
		
	    List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
	    
		return (W83bListadosBean)lista.get(0);		
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIListadosDAO#obtenerComarca(w83b.w83bBeans.W83bListadosBean)
	 */
	public w83b.w83bBeans.W83bListadosBean obtenerComarca(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		List params = new ArrayList();
		String c="";
		String p="";
		
	    strSql.append("SELECT ");

	    strSql.append(W83bListadosBD.dso).append(" AS ").append(W83bListadosBD.desccomarca);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bListadosBD.tablacomarca);
	    
	    strSql.append(" WHERE ");
	    
	    strSql.append(W83bListadosBD.provinciaid).append("=?");
	    
	    strSql.append(" AND ");
	    
	    strSql.append(W83bListadosBD.id).append("=?");
	    
	    if (param.getProvincia().length()==1){
	    	p="0"+param.getProvincia();
	    }
	    else{
	    	p=param.getProvincia();
	    }
	    if (param.getIdcomarca().length()==1){
	    	c="0"+param.getIdcomarca();
	    }
	    else{
	    	c=param.getIdcomarca();
	    }
	    params.add(p);
	    params.add(c);
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return (W83bListadosBean)lista.get(0);		
		
	}
	/**
	 * buscarRelacionBajas.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public List buscarRelacionBajas(W83bListadosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean restriccion = false;
		
		strSql.append("SELECT "); 
		strSql.append(W83bListadosBD.numActa).append(", TO_CHAR(");
		strSql.append(W83bListadosBD.fechaBaja).append(",?) ").append(W83bListadosBD.fechaBaja).append(",");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bListadosBD.motivoBaja).append(" as ").append(W83bListadosBD.motivoBaja).append(",");
			
		}
		else{
			strSql.append(W83bListadosBD.motivoBajaeu).append(" as ").append(W83bListadosBD.motivoBaja).append(",");
		}
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append(W83bListadosBD.nombre).append(", ");
		strSql.append(W83bListadosBD.sindicato).append(", ");
		strSql.append(W83bListadosBD.dni).append(", ");
		strSql.append(W83bListadosBD.nombreSustituto).append(", ");
		strSql.append(W83bListadosBD.sindicatoSustituto).append(", ");
		strSql.append(W83bListadosBD.dniSustituto).append(", ");
		strSql.append(W83bListadosBD.maximoDelegados);
		strSql.append(" FROM ").append(W83bListadosBD.vistaRelacionBajas);
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFechaBajaDesde())){
			restriccion=true;
			strSql.append(W83bListadosBD.fechaBaja).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaBajaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaBajaHasta())){
			if (restriccion){
				strSql.append(" AND ");
			}
			else{
				restriccion=true;
			}
			strSql.append(W83bListadosBD.fechaBaja).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaBajaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			if (restriccion){
				strSql.append(" AND ");
			}
			strSql.append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), null);
		
		return listaActas;	
	}
	/**
	 * buscarDelegadosActas.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public List buscarDelegadosActas(W83bListadosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83bListadosBD.numActa).append(",");
		strSql.append(W83bListadosBD.acta).append(",");
		strSql.append(W83bListadosBD.anyoActa).append(",");
		strSql.append(W83bListadosBD.territorio).append(",");
		strSql.append(W83bListadosBD.ver).append(",");
		strSql.append(W83bListadosBD.numRegistro).append(",");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bListadosBD.convenio).append(" as ").append(W83bListadosBD.convenio).append(",");
			
		}
		else{
			strSql.append(W83bListadosBD.convenioeu).append(" as ").append(W83bListadosBD.convenio).append(",");
		}
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append(W83bListadosBD.direccion).append(", ");
		strSql.append(W83bListadosBD.cif).append(", ");
		strSql.append(W83bListadosBD.codCentro).append(", ");
		strSql.append(W83bListadosBD.numelectores).append(", ");
		strSql.append(W83bListadosBD.delegadosHombres).append(", ");
		strSql.append(W83bListadosBD.delegadosMujeres).append(", ");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" AS SINDICATO, ");
			strSql.append(W83bColegiosBD.descripcion).append(" AS COLEGIO, ");
			strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast).append(" AS BAJA, ");
		}
		else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" AS SINDICATO, ");
			strSql.append(W83bColegiosBD.descripcion_eu).append(" AS COLEGIO, ");
			strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk).append(" AS BAJA, ");
		}
		strSql.append(W83bSindicatosBD.siglas).append(" AS SIGLAS, ");
		strSql.append(W83bDelegadosBD.dniSustituto).append(", ");
		strSql.append(W83bDelegadosBD.dni).append(", ");
		strSql.append(W83bDelegadosBD.sexo).append(", ");
		strSql.append(W83bDelegadosBD.fechaBaja).append(" AS F_BAJA_025, ");
		strSql.append(W83bDelegadosBD.nombre).append(", ");
		strSql.append(W83bDelegadosBD.apellido1).append(", ");
		strSql.append(W83bDelegadosBD.apellido2).append(", ");
		strSql.append(W83bDelegadosBD.codColegio).append(", ");
		strSql.append(W83bDelegadosBD.codSindicato);
		
		strSql.append(" FROM ").append(W83bListadosBD.vistaDelegadosNumeroActa).append(" ACTA");
		strSql.append(" WHERE");
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" ACTA.").append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		
		
		String hasta = param.getAnyoHasta();
		if(StringUtils.isEmpty(param.getAnyoHasta())){
			hasta = "9999";
		}
		String desde = param.getAnyoDesde();
		if(StringUtils.isEmpty(param.getAnyoDesde())){
			desde = "0000";
		}
		String numDesde = param.getNumActaDesde();
		String numHasta = param.getNumActaHasta();
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ACTA.").append(W83bListadosBD.nActaCompleto).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ACTA.").append(W83bListadosBD.nActaCompleto).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), "buscarDelegadosActas");
		
		return listaActas;	
	}
	/**
	 * buscarDelegadosIncompletos.
	 * 
	 * @param param the new parametro
	 * @return List the new baja
	 * @throws Exception the exception
	 */
	public List buscarDelegadosIncompletos(W83bListadosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		/*strSql.append("SELECT "); 
		strSql.append(W83bListadosBD.numActa).append(",");
		strSql.append(W83bListadosBD.acta).append(",");
		strSql.append(W83bListadosBD.anyoActa).append(",");
		strSql.append(W83bListadosBD.territorio).append(",");
		strSql.append(W83bListadosBD.ver).append(",");
		strSql.append(W83bListadosBD.numRegistro).append(",");
		strSql.append(W83bListadosBD.razon).append(", ");
		strSql.append(W83bListadosBD.numelectores).append(", ");
		strSql.append(" DEL, ");
		strSql.append(W83bListadosBD.maximoDelegados);
		strSql.append(" FROM ").append(W83bListadosBD.vistaDelegadosIncompletos).append(" ACTA");
		strSql.append(" WHERE");
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" ACTA.").append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		String desde = param.getAnyoDesde();
		String hasta = param.getAnyoHasta();
		String numDesde = param.getNumActaDesde();
		String numHasta = param.getNumActaHasta();
		if(StringUtils.isEmpty(param.getAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoHasta())){
			hasta = "9999";
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ACTA.").append(W83bListadosBD.nActaCompleto).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ACTA.").append(W83bListadosBD.nActaCompleto).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));*/

		strSql.append("SELECT ACTA.acta,ACTA.anoacta,ACTA.territ,ACTA.ver,ACTA.numRegistro,ACTA.razon, ");
		strSql.append(" ACTA.numelectores,  ACTA.DEL, ACTA.maximoDelegados , acta2.hombres AS delegadosHombres, acta2.mujeres as delegadosMujeres ");
		strSql.append(" FROM W83BDELEGADOSINCOMPLETOS2 ACTA, W83BDELEGADOSINCOMPLETOS3  acta2 WHERE ");
		strSql.append(" ACTA.territ=acta2.territ AND acta.acta=acta2.acta AND acta.ANOACTA=acta2.anoacta ");
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" AND ACTA.").append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		String desde = param.getAnyoDesde();
		String hasta = param.getAnyoHasta();
		String numDesde = param.getNumActaDesde();
		String numHasta = param.getNumActaHasta();
		if(StringUtils.isEmpty(param.getAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoHasta())){
			hasta = "9999";
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ACTA.").append(W83bListadosBD.nActaCompleto).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ACTA.").append(W83bListadosBD.nActaCompleto).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		
		strSql.append(" UNION SELECT acta,anoacta,territ,ver,numRegistro,razon, numelectores, ");
		strSql.append(" DEL, maximoDelegados , delh AS delegadosHombres, delm AS delegadosMujeres ");
		strSql.append(" FROM W83BDELEGADOSINCOMPLETOS2 ACTA WHERE ");
		strSql.append(" maximodelegados <> del ");
		if(StringUtils.isNotEmpty(param.getTerritorio())){
			strSql.append(" AND ACTA.").append(W83bListadosBD.territorio).append("=").append("?");
			params.add(param.getTerritorio());
		}
		desde = param.getAnyoDesde();
		hasta = param.getAnyoHasta();
		numDesde = param.getNumActaDesde();
		numHasta = param.getNumActaHasta();
		if(StringUtils.isEmpty(param.getAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoHasta())){
			hasta = "9999";
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ACTA.").append(W83bListadosBD.nActaCompleto).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ACTA.").append(W83bListadosBD.nActaCompleto).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		strSql.append(" ORDER BY acta,anoacta,territ,ver ");
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosBean.class,param.getUsuarioBean(), "buscarDelegadosIncompletos");
		
		return listaActas;	
	}
	
	/**
	 * Buscar actas vivas centros trabajo repetidos.
	 *
	 * @param param the param
	 * @param buscarMaximoVersion the buscar maximo version
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarActasVivasCentrosTrabajoRepetidos(W83bListadosActasVivasCentroRepeBean param) throws Exception {

		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.ano_acta).append(",");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.ccif).append(",");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.ncentrotrabajo).append(",");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.domic).append(",");
		strSql.append(" to_char(acta.").append(W83bListadosActasVivasCentroRepeBD.feleccion).append(",?) as ").append(W83bListadosActasVivasCentroRepeBD.feleccion).append(",");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.fentrada).append(",");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.municipio).append(",");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.nacta).append(",");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.numacta).append(",");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.versionActa).append(",");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.razonsocial).append(",");
		strSql.append(" DECODE(acta.").append(W83bListadosActasVivasCentroRepeBD.territorio).append(",'");
		strSql.append(W83bClsConstantes.CONSTANTE_ALAVA).append("','");
		strSql.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.alava",param.getIdioma().toString())).append("','");
		strSql.append(W83bClsConstantes.CONSTANTE_GIPUZKOA).append("','");
		strSql.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.gipuzkoa",param.getIdioma().toString())).append("','");
		strSql.append(W83bClsConstantes.CONSTANTE_BIZKAIA).append("','");
		strSql.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.bizkaia",param.getIdioma().toString())).append("') as territorioTxt,");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.municipio).append(",");
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
			strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.descConvenio).append(" as ").append(W83bListadosActasVivasCentroRepeBD.descConvenio).append(",");
		}else{
			strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.deseConvenio).append(" as ").append(W83bListadosActasVivasCentroRepeBD.descConvenio).append(",");			
		}
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.territorio);
		
		strSql.append(" FROM ").append(W83bListadosActasVivasCentroRepeBD.vistaListadosActasVivasCentroRepe).append(" acta");
		
		strSql.append(" WHERE");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.territorio).append(" = ").append("?");
		params.add(param.getTerritorio());
		
		strSql.append(" AND ");
		strSql.append(" acta.").append(W83bListadosActasVivasCentroRepeBD.idcentro).append(" in (");
		strSql.append(" SELECT t16_01.").append(W83bActasBD.codCentro);
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" t16_01 ");
		strSql.append(" WHERE t16_01.").append(W83bActasBD.numRegDefinitivo).append(" IS NOT NULL ");
		strSql.append(" AND t16_01.").append(W83bActasBD.fechaBaja).append(" IS  NULL ");
		strSql.append(" AND t16_01.").append(W83bActasBD.numTotalActa).append(" IS  NULL ");
		strSql.append(" AND t16_01.").append(W83bActasBD.codTerritActa).append(" = ? ");
		params.add(param.getTerritorio());
		strSql.append(" AND ");
		strSql.append(" T16_01.").append(W83bActasBD.versionActa).append(" = ");
		strSql.append(" (select max(t16temp.").append(W83bActasBD.versionActa).append(") ");
		strSql.append(" from ").append(W83bActasBD.actasTable).append(" t16temp ");
		strSql.append(" where t16temp.").append(W83bActasBD.anyoActa).append(" = ");
		strSql.append(" t16_01.").append(W83bActasBD.anyoActa);
		strSql.append(" and t16temp.").append(W83bActasBD.numActa).append(" = ");
		strSql.append(" t16_01.").append(W83bActasBD.numActa);
		strSql.append(" and t16temp.").append(W83bActasBD.codTerritActa).append(" = ");
		strSql.append(" t16_01.").append(W83bActasBD.codTerritActa).append(") ");
		strSql.append(" AND t16_01.").append(W83bActasBD.codCentro).append(" IN(");
		strSql.append(" SELECT t16_02.").append(W83bActasBD.codCentro);
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" t16_02 ");
		strSql.append(" WHERE T16_02.").append(W83bActasBD.fechaEntrada).append(" >= TO_DATE(?,?)");
		params.add(param.getFentrada());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(" AND T16_02.").append(W83bActasBD.numRegDefinitivo).append(" IS NOT NULL ");
		strSql.append(" AND T16_02.").append(W83bActasBD.fechaBaja).append(" IS  NULL ");
		strSql.append(" AND T16_02.").append(W83bActasBD.numTotalActa).append(" IS  NULL ");
		strSql.append(" AND T16_02.").append(W83bActasBD.codTerritActa).append(" = ? ");
		params.add(param.getTerritorio());
		strSql.append(" AND ");
		strSql.append(" T16_02.").append(W83bActasBD.versionActa).append(" = ");
		strSql.append(" (select max(t16temp.").append(W83bActasBD.versionActa).append(") ");
		strSql.append(" from ").append(W83bActasBD.actasTable).append(" t16temp ");
		strSql.append(" where t16temp.").append(W83bActasBD.anyoActa).append(" = ");
		strSql.append(" T16_02.").append(W83bActasBD.anyoActa);
		strSql.append(" and t16temp.").append(W83bActasBD.numActa).append(" = ");
		strSql.append(" T16_02.").append(W83bActasBD.numActa);
		strSql.append(" and t16temp.").append(W83bActasBD.codTerritActa).append(" = ");
		strSql.append(" T16_02.").append(W83bActasBD.codTerritActa).append(") ");
		strSql.append(")");
		strSql.append(" GROUP BY T16_01.").append(W83bActasBD.codCentro);
		strSql.append(" HAVING COUNT (T16_01.").append(W83bActasBD.codCentro).append(")>1");
		strSql.append(") ");
		
		strSql.append(" ORDER BY ").append(W83bListadosActasVivasCentroRepeBD.ccif);
		strSql.append(", ").append(W83bListadosActasVivasCentroRepeBD.territorio);
		strSql.append(", ").append(W83bListadosActasVivasCentroRepeBD.ano_acta);
		strSql.append(", ").append(W83bListadosActasVivasCentroRepeBD.numacta);
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bListadosActasVivasCentroRepeBean.class,param.getUsuarioBean(), param.getIdioma());
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIListadosDAO#anularActaPorFechaEleccion(w83b.w83bBeans.W83bListadosActasVivasCentroRepeBean, java.lang.String)
	 */
	public String anularActaPorFechaEleccion(W83bListadosActasVivasCentroRepeBean param,String fecBaja) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		
		List params = new ArrayList();
		strSql.append("UPDATE ");
		strSql.append(W83bActasBD.tablaActas);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.fechaBaja).append(" = TO_DATE(?,?) ");
		strSql.append(", ");
		strSql.append(W83bActasBD.codMotivosBaja).append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bActasBD.observaciones).append(" = ? ");
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=?");

	    params.add(fecBaja);
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(new Integer(W83bClsConstantes.CONSTANTE_MOTIVO_BAJA_ANULACION_ACTA_FECHAELECCION));
		params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.listados.nuevaEleccion",param.getIdioma()).toUpperCase());		
		
		params.add(param.getNacta());
		params.add(param.getAno_acta());
		params.add(param.getTerritorio());
		
		W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		
		return "0";
	}
	
	
	public List buscarDelegadosActa(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		List params = new ArrayList();
		strSql.append("SELECT COUNT(").append(W83bDelegadosBD.dni).append(") AS DELEGADOS,");
		strSql.append(W83bDelegadosBD.sexo).append(",").append(W83bDelegadosBD.codSindicato).append(",");
		strSql.append(W83bDelegadosBD.codColegio);
		strSql.append(", TO_CHAR(");
		strSql.append(W83bDelegadosBD.fechaBaja).append(",?) ").append(W83bDelegadosBD.fechaBaja);
		/*strSql.append(W83bDelegadosBD.baja).append(",");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" SINDICATO,").append(W83bColegiosBD.descripcion).append(" COLEGIO,");
			strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast).append(" BAJA");
		}
		else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" SINDICATO,").append(W83bColegiosBD.descripcion_eu).append(" COLEGIO,");
			strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk).append(" BAJA");
		}*/
		
		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosTable).append(",").append(W83bSindicatosBD.sindicatosTable).append(",");
		strSql.append(W83bColegiosBD.colegiosTable).append(",").append(W83bMotivosBajaDelegadoBD.motivosBajaTable);
		strSql.append(" WHERE ").append(W83bDelegadosBD.acta).append("=? AND ").append(W83bDelegadosBD.anyoActa).append("=? AND ");
		strSql.append(W83bDelegadosBD.territorioActa).append("=? AND ").append(W83bDelegadosBD.versionActa).append("=? AND ");
		strSql.append(W83bDelegadosBD.codSindicato).append("=").append(W83bSindicatosBD.codSindicato).append(" AND ");
		strSql.append(W83bDelegadosBD.codColegio).append("=").append(W83bColegiosBD.cod).append(" AND ");
		strSql.append(W83bDelegadosBD.baja).append("=").append(W83bMotivosBajaDelegadoBD.codMotivo).append("(+)");
		strSql.append(" GROUP BY ").append(W83bDelegadosBD.codSindicato).append(", ").append(W83bDelegadosBD.codColegio).append(", ");
		strSql.append(W83bDelegadosBD.sexo).append(", ").append(W83bDelegadosBD.dni).append(", ");
		strSql.append(W83bDelegadosBD.codColegio).append(",").append(W83bDelegadosBD.apellido1).append(",").append(W83bDelegadosBD.apellido2).append(",");
		strSql.append(W83bDelegadosBD.nombre).append(",").append(W83bDelegadosBD.dniSustituto).append(", ");
		strSql.append(W83bDelegadosBD.fechaAlta).append(", ").append(W83bDelegadosBD.fechaBaja).append(",");
		strSql.append(W83bDelegadosBD.baja).append(",");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(",").append(W83bColegiosBD.descripcion).append(",");
			strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast);
		}
		else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(",").append(W83bColegiosBD.descripcion_eu).append(",");
			strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk);
		}
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		//params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListaDelegadosBean.class,param.getUsuarioBean(), "DETALLE2");
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		return listaActas;	
	}
	
}